function [ HRVtop, HRVbot ] = Sub_Equilibrate_Side_V03( V, Radius, PVHS_bot, PVHS_top, Height, log )

%UNTITLED3 Summary of this function goes here
%   Detailed explanation goes here

% Global physical variables
global gamma rho g ;

% ---------------
% Simulation variables
% ---------------
Vcyl   = pi * Radius * Radius * Height ; % Volume of the cylinder
Vbot   = (V-Vcyl) / 2     ; % starting volume of the top spherical cap
Vtop   = (V-Vcyl) / 2     ; % starting volume of the bottom spherical cap

% ---------------
% Simulation parameters
% ---------------
simEnd  = 1e-4    ; % Threshold at which the simulation stops
epsilon = 0.0001    ; % Factor to calculate volume exchange at each step

% ---------------
% Useful functions
% ---------------
radius = @(h,a) (h^2 + a^2)/(2*h)         ; % radius of a spherical cap in function of height and radius of the port

% ---------------
% Setup arrays to plot the evolution of the radii
% ---------------
n        = 4000            ;
Rtopm    = zeros(n,1)      ;
Rbotm    = zeros(n,1)      ;
Ptopm    = zeros(n,1)      ;
Pbotm    = zeros(n,1)      ;
Vtopm    = zeros(n,1)      ;
Vbotm    = zeros(n,1)      ;

% ---------------
% Start the simulation
% ---------------

% While the system is not equilibrated, exchange volume between the 
% two drops
index = 1;
while true
    
    % Calculate the pressures, curvatures of radiii, and height of the 
    % top spherical caps...
    % This one is based on the young laplace equation
    %Htop = Function_Height_Volume_V03(Vtop,Radius) ; % Height of the spherical cap
    %Rtop = radius(Htop,Radius)                     ; % Radius of the spherical cap
    %Ptop = 2 * gamma / Rtop                        ; % Pressure of the spherical cap
    Ptop = ppval(PVHS_top.PV,Vtop)                    ; % Find the pressure given volume Vbot
    Rtop = 2 * gamma / Ptop                           ; % Find the radius of survature
    Htop = ppval(PVHS_top.HV,Vtop)                    ; % Find the height of the pendant drop given volume Vbot
    
    % Calculate the pressures, curvatures of radiii, and height of the 
    % bottom spherical caps...
    % This one is based on the Pressure-volume-height table provided
    %Abot = ppval(PVHS_bot.surfaces,Vbot)              ; % Find the surface of the pendant drop
    %Mbot = rho * Vbot + Vcyl * rho                    ; % Calculate the weight of the water in the droplet
    Hbot = ppval(PVHS_bot.HV,Vbot)                    ; % Find the height of the pendant drop given volume Vbot
    Phyd = rho * g * (Hbot + Height)                  ; % Hydrostatic pressure
    Pbot = ppval(PVHS_bot.PV,Vbot) - Phyd             ; % Find the pressure given volume Vbot
    Rbot = 2 * gamma / Pbot                           ; % Find the radius of survature
     
    % Set the variables to display
    Rtopm(index) = Rtop ; % Curvature of radius of drop 1
    Rbotm(index) = Rbot ; % Curvature of radius of drop 1
    Ptopm(index) = Ptop ; % Curvature of radius of drop 1
    Pbotm(index) = Pbot ; % Curvature of radius of drop 1
    Vtopm(index) = Vtop + Vcyl/2 ; % Curvature of radius of drop 1
    Vbotm(index) = Vbot + Vcyl/2 ; % Curvature of radius of drop 1
    
    % Calculating the pressure difference between drop 1 and 2 and testing
    % for the equilibration condition
    pressure_diff = Ptop - Pbot ;

    % Calculate the pressure difference and if it's lower than the 
    % equilibration conditions then flag the simulation to stop
    if abs(pressure_diff) < simEnd
        %display(['Port equilibrium reached after ' num2str(index) '  =  ' num2str(pressure_diff)]);
        break ;
    end
    
    if (Vtop<0 || Vbot<0)
        if log == true
            display('Equilibrate TOP-BOTTOM Simulation crashed, negative values');
        end
        break ;
    end
    
    % if the index is too high, escape the loop
    if index > n
        if log == true
            display(['Port equilibrium NOT reached after ' num2str(index) '  =  ' num2str(pressure_diff)]);
        end
        break;
    end
    
    % Exchange some fluid between the two caps
    dV = epsilon * pressure_diff * V;
    Vtop = Vtop - dV ;
    Vbot = Vbot + dV ;
    
    % increment while loop index
    index = index + 1;
end

P = Ptop ;
Vtop = Vtop + Vcyl/2 ;
Vbot = Vbot + Vcyl/2 ;
    
% Save the variables in a structure
HRVtop = struct('height', Htop, 'radius', Rtop, 'volume', Vtop, 'pressure', Ptop);
HRVbot = struct('height', Hbot, 'radius', Rbot, 'volume', Vbot, 'pressure', Pbot);

end

